/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.analysis.filesystem;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.sonar.api.batch.BatchSide;
import org.sonar.api.batch.fs.InputDir;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.DefaultFileSystem;

@BatchSide
public class InputPathCache
extends DefaultFileSystem.Cache {
    private final Map<Path, InputFile> inputFileCache = Maps.newLinkedHashMap();
    private final Set<InputDir> inputDirCache = Sets.newHashSet();

    @Override
    public Iterable<InputFile> inputFiles() {
        return this.inputFileCache.values();
    }

    public Iterable<InputDir> allDirs() {
        return this.inputDirCache;
    }

    @Override
    public void doAdd(InputFile inputFile) {
        this.inputFileCache.put(inputFile.path(), inputFile);
    }

    @Override
    public void doAdd(InputDir inputDir) {
        this.inputDirCache.add(inputDir);
    }

    @Override
    public InputFile inputFile(String relativePath) {
        return null;
    }

    @Override
    public InputDir inputDir(String relativePath) {
        return null;
    }

    public InputFile inputFile(Path path) {
        return this.inputFileCache.get(path);
    }
}

